/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilepayment;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptUtil {
    public static final String PUBLIC_KEY = "PUBLIC_KEY";
    public static final String PRIVATE_KEY = "PRIVATE_KEY";

    private EncryptUtil() {
    }

    public static boolean verifySign(String key, String input, String signed) throws Exception {
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = Base64.decodeBase64((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Signature verifySign = Signature.getInstance("SHA256withRSA/PSS", (Provider)new BouncyCastleProvider());
        verifySign.initVerify(publicKey);
        verifySign.update(data);
        return verifySign.verify(Base64.decodeBase64((String)signed));
    }

    public static String encodeSHA256withRSA(String key, String input) throws Exception {
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = Base64.decodeBase64((String)key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Signature sign = Signature.getInstance("SHA256withRSA/PSS", (Provider)new BouncyCastleProvider());
        sign.initSign(privateKey);
        sign.update(data);
        byte[] signed = sign.sign();
        return Base64.encodeBase64String((byte[])signed);
    }

    public static String encodeHMACSHA256(String key, String input) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        if (keyBytes.length != 32) {
            throw new InvalidKeyException("Invalid Hmac Key!");
        }
        Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        hmacSHA256.init(secretKey);
        byte[] bytes = hmacSHA256.doFinal(input.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])bytes);
    }

    public static String encodeSHA256(String input) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(input.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])messageDigest.digest());
    }

    public static Map<String, String> genRSAKeyPair(int keySize) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(keySize, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        String privateKeyStr = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, publicKeyStr);
        keyMap.put(PRIVATE_KEY, privateKeyStr);
        return keyMap;
    }

    public static String genMacKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacSHA256");
        SecretKey secretKey = keyGenerator.generateKey();
        String secretKeyStr = Base64.encodeBase64String((byte[])secretKey.getEncoded());
        return secretKeyStr;
    }
}

