/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilepayment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.mobilepayment.EncryptUtil;
import com.huawei.mobilepayment.tools.data.SignType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class SignUtils {
    private static Set<String> excludeKey = new HashSet<String>(){
        {
            this.add("sign_type");
            this.add("sign");
            this.add("header");
        }
    };

    private SignUtils() {
    }

    public static String generateNonceStr() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }

    public static String joinKeyValue(Map<String, String> flatMap) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        flatMap.entrySet().stream().filter(keyVal -> StringUtils.isNotEmpty((CharSequence)keyVal.getValue())).filter(keyVal -> ((String)keyVal.getValue()).trim().length() > 0).sorted(Map.Entry.comparingByKey()).forEachOrdered(keyVal -> {
            stringBuilder.append("&");
            stringBuilder.append((String)keyVal.getKey()).append("=").append(((String)keyVal.getValue()).trim());
        });
        return stringBuilder.substring(1);
    }

    public static Map<String, String> transJson2Map(JSONObject waitSignData, Set<String> excludeSignKey) {
        HashMap<String, String> flatMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : waitSignData.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (excludeSignKey.contains(key) || (value = entry.getValue()) instanceof JSONArray) continue;
            if (value instanceof JSONObject) {
                flatMap.putAll(SignUtils.transJson2Map((JSONObject)value, excludeSignKey));
                continue;
            }
            if (value == null) continue;
            flatMap.put(entry.getKey(), String.valueOf(value));
        }
        return flatMap;
    }

    public static String generateSignSrc(String request) {
        JSONObject jsonObject = JSONObject.parseObject(request);
        Map<String, String> waitSignPair = SignUtils.transJson2Map(jsonObject, excludeKey);
        return SignUtils.joinKeyValue(waitSignPair);
    }

    public static String generateSign(String key, SignType signType, String waitSignData) throws Exception {
        switch (signType) {
            case SHA256: {
                return EncryptUtil.encodeSHA256(waitSignData);
            }
            case SHA256_RSA: {
                return EncryptUtil.encodeSHA256withRSA(key, waitSignData);
            }
            case HMAC_SHA256: {
                return EncryptUtil.encodeHMACSHA256(key, waitSignData);
            }
        }
        return null;
    }

    public static boolean checkSign(String key, SignType signType, String waitSignData, String signed) throws Exception {
        String sign = null;
        switch (signType) {
            case SHA256: {
                sign = EncryptUtil.encodeSHA256(waitSignData);
                return StringUtils.equals(sign, signed);
            }
            case SHA256_RSA: {
                return EncryptUtil.verifySign(key, waitSignData, signed);
            }
            case HMAC_SHA256: {
                sign = EncryptUtil.encodeHMACSHA256(key, waitSignData);
                return StringUtils.equals(sign, signed);
            }
        }
        return false;
    }
}

