/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilepayment;

import com.alibaba.fastjson.JSONObject;
import com.huawei.mobilepayment.EncryptUtil;
import com.huawei.mobilepayment.SignUtils;
import com.huawei.mobilepayment.tools.data.SignData;
import com.huawei.mobilepayment.tools.data.SignType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    private JPanel panel1;
    private JTabbedPane tabbedPane1;
    private JTextArea textRequest;
    private JRadioButton hmacSHA256RadioButton;
    private JRadioButton sha256WithRSARadioButton;
    private JRadioButton sha256RadioButton;
    private JTextArea textSign;
    private JButton signButton;
    private JTextArea textSecretKey;
    private JTextArea textSignSrc;
    private JTextArea textPriKey;
    private JTextArea textPubKey;
    private JRadioButton signRSARadioButton;
    private JRadioButton signHmacRadioButton;
    private JButton generateButton;
    private JTextArea textCheckSecretKey;
    private JTextArea textCheckSign;
    private JTextField textCheckResult;
    private JTextArea textCheckRequest;
    private JRadioButton checkSha256RadioButton;
    private JButton checkButton;
    private JRadioButton checkRsaRadioButton;
    private JRadioButton checkHmacRadioButton;
    private JComboBox keySizeComboBox;
    private SignType generateSignType = SignType.SHA256_RSA;
    private SignData signData;
    private SignData checkSignData;

    public void checkSign() {
        this.getCheckData(this.checkSignData);
        if (StringUtils.isEmpty(this.checkSignData.getRequest())) {
            JOptionPane.showMessageDialog(null, "The Request Message can not be empty!", "ERROR_MESSAGE", 0);
            return;
        }
        if (!JSONObject.isValid(this.checkSignData.getRequest())) {
            JOptionPane.showMessageDialog(null, "The Request Message is not Json format!", "ERROR_MESSAGE", 0);
            return;
        }
        String signSrc = SignUtils.generateSignSrc(this.checkSignData.getRequest());
        this.checkSignData.setSignSrc(signSrc);
        if (this.checkSignData.getSignType().compareTo(SignType.SHA256) != 0 && StringUtils.isEmpty(this.checkSignData.getKey())) {
            JOptionPane.showMessageDialog(null, "The Secret Key can not be empty!", "ERROR_MESSAGE", 0);
            return;
        }
        boolean isValid = true;
        try {
            isValid = SignUtils.checkSign(this.checkSignData.getKey(), this.checkSignData.getSignType(), this.checkSignData.getSignSrc(), this.checkSignData.getSign());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR_MESSAGE", 0);
            return;
        }
        this.textCheckResult.setText("Check Success\uff01\uff01\uff01");
        this.textCheckResult.setForeground(Color.GREEN);
        if (!isValid) {
            this.textCheckResult.setText("Check Failed\uff01\uff01\uff01");
            this.textCheckResult.setForeground(Color.RED);
        }
    }

    public void generateKey() {
        try {
            switch (this.generateSignType) {
                case SHA256_RSA: {
                    Map<String, String> map = EncryptUtil.genRSAKeyPair(Integer.parseInt(this.keySizeComboBox.getSelectedItem().toString()));
                    this.textPriKey.setText(map.get("PRIVATE_KEY"));
                    this.textPubKey.setText(map.get("PUBLIC_KEY"));
                    break;
                }
                case HMAC_SHA256: {
                    String macKey = EncryptUtil.genMacKey();
                    this.textPriKey.setText(null);
                    this.textPubKey.setText(macKey);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR_MESSAGE", 0);
            return;
        }
    }

    public void sign() {
        this.getData(this.signData);
        if (StringUtils.isEmpty(this.signData.getRequest())) {
            JOptionPane.showMessageDialog(null, "The Request Message can not be empty!", "ERROR_MESSAGE", 0);
            return;
        }
        if (!JSONObject.isValid(this.signData.getRequest())) {
            JOptionPane.showMessageDialog(null, "The Request Message is not Json format!", "ERROR_MESSAGE", 0);
            return;
        }
        String signSrc = SignUtils.generateSignSrc(this.signData.getRequest());
        this.signData.setSignSrc(signSrc);
        this.setData(this.signData);
        if (this.signData.getSignType().compareTo(SignType.SHA256) != 0 && StringUtils.isEmpty(this.signData.getKey())) {
            JOptionPane.showMessageDialog(null, "The Secret Key can not be empty!", "ERROR_MESSAGE", 0);
            return;
        }
        try {
            String sign = SignUtils.generateSign(this.signData.getKey(), this.signData.getSignType(), signSrc);
            this.signData.setSign(sign);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR_MESSAGE", 0);
            return;
        }
        this.setData(this.signData);
    }

    public Tools() {
        this.$$$setupUI$$$();
        this.checkSignData = new SignData();
        this.signData = new SignData();
        this.keySizeComboBox.setSelectedItem("3072");
        this.signData.setSignType(SignType.SHA256_RSA);
        this.checkSignData.setSignType(SignType.SHA256_RSA);
        this.signButton.addActionListener(e -> this.sign());
        this.sha256RadioButton.setVisible(false);
        this.checkSha256RadioButton.setVisible(false);
        this.sha256WithRSARadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.signData.setSignType(SignType.SHA256_RSA);
                this.textSign.setText(null);
            }
        });
        this.hmacSHA256RadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.signData.setSignType(SignType.HMAC_SHA256);
                this.textSign.setText(null);
            }
        });
        this.sha256RadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.signData.setSignType(SignType.SHA256);
                this.textSign.setText(null);
            }
        });
        this.generateButton.addActionListener(e -> this.generateKey());
        this.signRSARadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.generateSignType = SignType.SHA256_RSA;
                this.textPriKey.setText(null);
                this.textPubKey.setText(null);
                this.keySizeComboBox.setEnabled(true);
                this.textPubKey.setEnabled(true);
                this.textPriKey.setEnabled(true);
            }
        });
        this.signHmacRadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.generateSignType = SignType.HMAC_SHA256;
                this.textPriKey.setText(null);
                this.textPubKey.setText(null);
                this.textPubKey.setEnabled(true);
                this.textPriKey.setEnabled(false);
                this.keySizeComboBox.setEnabled(false);
            }
        });
        this.checkButton.addActionListener(e -> this.checkSign());
        this.checkRsaRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Tools.this.checkSignData.setSignType(SignType.SHA256_RSA);
                    Tools.this.textCheckResult.setText(null);
                }
            }
        });
        this.checkHmacRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Tools.this.checkSignData.setSignType(SignType.HMAC_SHA256);
                    Tools.this.textCheckResult.setText(null);
                }
            }
        });
        this.checkSha256RadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Tools.this.checkSignData.setSignType(SignType.SHA256);
                    Tools.this.textCheckResult.setText(null);
                }
            }
        });
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Sign Tools Ver1.1");
        JPanel rootPane = new Tools().panel1;
        frame.setContentPane(rootPane);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(rootPane);
        frame.setVisible(true);
    }

    public void getCheckData(SignData data) {
        data.setRequest(this.textCheckRequest.getText().trim());
        data.setSign(this.textCheckSign.getText());
        data.setKey(this.textCheckSecretKey.getText().trim());
    }

    public void setData(SignData data) {
        this.textRequest.setText(data.getRequest());
        this.textSign.setText(data.getSign());
        this.textSignSrc.setText(data.getSignSrc());
    }

    public void getData(SignData data) {
        data.setRequest(this.textRequest.getText().trim());
        data.setSignSrc(this.textSignSrc.getText());
        data.setSign(this.textSign.getText());
        data.setKey(this.textSecretKey.getText().trim());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JRadioButton jRadioButton;
        JTextField jTextField;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JTextArea jTextArea;
        JTextArea jTextArea2;
        JTextArea jTextArea3;
        JTextArea jTextArea4;
        JTextArea jTextArea5;
        JTextArea jTextArea6;
        JTextArea jTextArea7;
        JRadioButton jRadioButton4;
        JButton jButton2;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JComboBox jComboBox;
        JButton jButton3;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JTextArea jTextArea8;
        JTextArea jTextArea9;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.panel1 = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        this.tabbedPane1 = jTabbedPane = new JTabbedPane();
        jTabbedPane.setMaximumSize(new Dimension(421, 305));
        jTabbedPane.setPreferredSize(new Dimension(421, 305));
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Generate Key", null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(3, 1, 1, 4, 0, 3, 7, 7, null, null, null));
        this.textPriKey = jTextArea9 = new JTextArea();
        jTextArea9.setLineWrap(true);
        jScrollPane.setViewportView(jTextArea9);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel2.add((Component)jScrollPane2, new GridConstraints(2, 1, 1, 4, 0, 3, 7, 7, null, null, null));
        this.textPubKey = jTextArea8 = new JTextArea();
        jTextArea8.setEditable(false);
        jTextArea8.setLineWrap(true);
        jTextArea8.setText("");
        jScrollPane2.setViewportView(jTextArea8);
        JLabel jLabel = new JLabel();
        jLabel.setText("Public Key\uff1a");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Sign Type\uff1a");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.signRSARadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(true);
        jRadioButton8.setText("SHA256WithRSA");
        jPanel2.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(139, 19), null));
        this.signHmacRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("HmacSHA256");
        jPanel2.add((Component)jRadioButton7, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Private Key\uff1a");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateButton = jButton3 = new JButton();
        jButton3.setText("Generate");
        jPanel2.add((Component)jButton3, new GridConstraints(1, 1, 1, 3, 0, 1, 3, 0, null, null, null));
        this.keySizeComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("1024");
        defaultComboBoxModel.addElement("2048");
        defaultComboBoxModel.addElement("3072");
        defaultComboBoxModel.addElement("4096");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("KeySize");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setPreferredSize(new Dimension(421, 305));
        jTabbedPane.addTab("Sign", null, jPanel3, null);
        this.sha256WithRSARadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setSelected(true);
        jRadioButton6.setText("SHA256WithRSA");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jRadioButton6, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Sign Type\uff1a");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.anchor = 17;
        jPanel3.add((Component)jLabel5, gridBagConstraints2);
        this.hmacSHA256RadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("HmacSHA256");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        jPanel3.add((Component)jRadioButton5, gridBagConstraints3);
        this.signButton = jButton2 = new JButton();
        jButton2.setText("Sign");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        jPanel3.add((Component)jButton2, gridBagConstraints4);
        this.sha256RadioButton = jRadioButton4 = new JRadioButton();
        ((Component)jRadioButton4).setEnabled(false);
        jRadioButton4.setText("SHA256");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        jPanel3.add((Component)jRadioButton4, gridBagConstraints5);
        JScrollPane jScrollPane3 = new JScrollPane();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.fill = 1;
        jPanel3.add((Component)jScrollPane3, gridBagConstraints6);
        this.textRequest = jTextArea7 = new JTextArea();
        jTextArea7.setLineWrap(true);
        jTextArea7.setMaximumSize(new Dimension(-1, -1));
        jTextArea7.setText("");
        jScrollPane3.setViewportView(jTextArea7);
        JScrollPane jScrollPane4 = new JScrollPane();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.fill = 1;
        jPanel3.add((Component)jScrollPane4, gridBagConstraints7);
        this.textSecretKey = jTextArea6 = new JTextArea();
        jTextArea6.setLineWrap(true);
        jScrollPane4.setViewportView(jTextArea6);
        JScrollPane jScrollPane5 = new JScrollPane();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.fill = 1;
        jPanel3.add((Component)jScrollPane5, gridBagConstraints8);
        this.textSignSrc = jTextArea5 = new JTextArea();
        jTextArea5.setEditable(false);
        jTextArea5.setLineWrap(true);
        jScrollPane5.setViewportView(jTextArea5);
        JScrollPane jScrollPane6 = new JScrollPane();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 5;
        gridBagConstraints9.gridwidth = 3;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.fill = 1;
        jPanel3.add((Component)jScrollPane6, gridBagConstraints9);
        this.textSign = jTextArea4 = new JTextArea();
        jTextArea4.setEditable(false);
        jTextArea4.setLineWrap(true);
        jScrollPane6.setViewportView(jTextArea4);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Sign\uff1a");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 5;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.anchor = 17;
        jPanel3.add((Component)jLabel6, gridBagConstraints10);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Sign Source\uff1a");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 4;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.anchor = 17;
        jPanel3.add((Component)jLabel7, gridBagConstraints11);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Secret Key\uff1a ");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 1;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.anchor = 17;
        jPanel3.add((Component)jLabel8, gridBagConstraints12);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Request Message\uff1a");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.weighty = 1.0;
        gridBagConstraints13.anchor = 17;
        jPanel3.add((Component)jLabel9, gridBagConstraints13);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Check Sign", null, jPanel4, null);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Sign\uff1a ");
        jPanel4.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Secret Key\uff1a ");
        jPanel4.add((Component)jLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Sign Type\uff1a");
        jPanel4.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Check Result\uff1a");
        jPanel4.add((Component)jLabel13, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Request Message\uff1a");
        jPanel4.add((Component)jLabel14, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane7 = new JScrollPane();
        jPanel4.add((Component)jScrollPane7, new GridConstraints(3, 1, 1, 3, 0, 3, 7, 7, null, null, null));
        this.textCheckRequest = jTextArea3 = new JTextArea();
        jTextArea3.setLineWrap(true);
        jScrollPane7.setViewportView(jTextArea3);
        JScrollPane jScrollPane8 = new JScrollPane();
        jPanel4.add((Component)jScrollPane8, new GridConstraints(2, 1, 1, 3, 0, 3, 7, 7, null, null, null));
        this.textCheckSign = jTextArea2 = new JTextArea();
        jTextArea2.setLineWrap(true);
        jScrollPane8.setViewportView(jTextArea2);
        JScrollPane jScrollPane9 = new JScrollPane();
        jPanel4.add((Component)jScrollPane9, new GridConstraints(1, 1, 1, 3, 0, 3, 7, 7, null, null, null));
        this.textCheckSecretKey = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jScrollPane9.setViewportView(jTextArea);
        this.checkRsaRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("SHA256WithRSA");
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.checkHmacRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("HmacSHA256");
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.textCheckResult = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(5, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.checkSha256RadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("SHA256");
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.checkButton = jButton = new JButton();
        jButton.setText("Check");
        jPanel4.add((Component)jButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

